@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies that the content key ID is in the PlayReady header.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
 */
public data class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs(
    public val odataType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgsBuilder internal
constructor() {
    private var odataType: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
     */
    @JvmName("denigdmktohbetts")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
     */
    @JvmName("cjfylcgcildaorum")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs =
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs(
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
