@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
 * @property bestEffort Indicates whether this restriction is enforced on a Best Effort basis.
 * @property configurationData Configures the restriction control bits. Must be between 0 and 3 inclusive.
 */
public data class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs(
    public val bestEffort: Output<Boolean>,
    public val configurationData: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs.builder()
            .bestEffort(bestEffort.applyValue({ args0 -> args0 }))
            .configurationData(configurationData.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgsBuilder internal
constructor() {
    private var bestEffort: Output<Boolean>? = null

    private var configurationData: Output<Int>? = null

    /**
     * @param value Indicates whether this restriction is enforced on a Best Effort basis.
     */
    @JvmName("crphsonbrwemuogw")
    public suspend fun bestEffort(`value`: Output<Boolean>) {
        this.bestEffort = value
    }

    /**
     * @param value Configures the restriction control bits. Must be between 0 and 3 inclusive.
     */
    @JvmName("jhtsxlreyhyncjmm")
    public suspend fun configurationData(`value`: Output<Int>) {
        this.configurationData = value
    }

    /**
     * @param value Indicates whether this restriction is enforced on a Best Effort basis.
     */
    @JvmName("cnfaeefqmbnyqwkx")
    public suspend fun bestEffort(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bestEffort = mapped
    }

    /**
     * @param value Configures the restriction control bits. Must be between 0 and 3 inclusive.
     */
    @JvmName("apibifadcgwjokax")
    public suspend fun configurationData(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationData = mapped
    }

    internal fun build(): ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs =
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs(
            bestEffort = bestEffort ?: throw PulumiNullFieldException("bestEffort"),
            configurationData = configurationData ?: throw PulumiNullFieldException("configurationData"),
        )
}
