@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenClaimArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a token claim.
 * @property claimType Token claim type.
 * @property claimValue Token claim value.
 */
public data class ContentKeyPolicyTokenClaimArgs(
    public val claimType: Output<String>? = null,
    public val claimValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenClaimArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenClaimArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenClaimArgs.builder()
            .claimType(claimType?.applyValue({ args0 -> args0 }))
            .claimValue(claimValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyTokenClaimArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyTokenClaimArgsBuilder internal constructor() {
    private var claimType: Output<String>? = null

    private var claimValue: Output<String>? = null

    /**
     * @param value Token claim type.
     */
    @JvmName("xnvqnxomxundcexp")
    public suspend fun claimType(`value`: Output<String>) {
        this.claimType = value
    }

    /**
     * @param value Token claim value.
     */
    @JvmName("dilroamwanfmypgc")
    public suspend fun claimValue(`value`: Output<String>) {
        this.claimValue = value
    }

    /**
     * @param value Token claim type.
     */
    @JvmName("ulmtjplnewhfxhgn")
    public suspend fun claimType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claimType = mapped
    }

    /**
     * @param value Token claim value.
     */
    @JvmName("vykffpfgdfqfrhtj")
    public suspend fun claimValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claimValue = mapped
    }

    internal fun build(): ContentKeyPolicyTokenClaimArgs = ContentKeyPolicyTokenClaimArgs(
        claimType = claimType,
        claimValue = claimValue,
    )
}
