@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.DDAudioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes Dolby Digital Audio Codec (AC3) audio encoding settings. The current implementation for Dolby Digital Audio support are: Audio channel numbers at 1((mono), 2(stereo), 6(5.1side); Audio sampling frequency rates at: 32K/44.1K/48K Hz; Audio bitrate values as AC3 specification supports: 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000 bps.
 * @property bitrate The bitrate, in bits per second, of the output encoded audio.
 * @property channels The number of channels in the audio.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.DDAudio'.
 * @property samplingRate The sampling rate to use for encoding in hertz.
 */
public data class DDAudioArgs(
    public val bitrate: Output<Int>? = null,
    public val channels: Output<Int>? = null,
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
    public val samplingRate: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.DDAudioArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.DDAudioArgs =
        com.pulumi.azurenative.media.inputs.DDAudioArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .channels(channels?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .samplingRate(samplingRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DDAudioArgs].
 */
@PulumiTagMarker
public class DDAudioArgsBuilder internal constructor() {
    private var bitrate: Output<Int>? = null

    private var channels: Output<Int>? = null

    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    private var samplingRate: Output<Int>? = null

    /**
     * @param value The bitrate, in bits per second, of the output encoded audio.
     */
    @JvmName("jdmtqbkorkcskpau")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value The number of channels in the audio.
     */
    @JvmName("pmeobviauawjcqlj")
    public suspend fun channels(`value`: Output<Int>) {
        this.channels = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("kkiftcqjyoqkrfin")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.DDAudio'.
     */
    @JvmName("qmyhrbcjepbggvcy")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The sampling rate to use for encoding in hertz.
     */
    @JvmName("ssdlgglsywwjqxel")
    public suspend fun samplingRate(`value`: Output<Int>) {
        this.samplingRate = value
    }

    /**
     * @param value The bitrate, in bits per second, of the output encoded audio.
     */
    @JvmName("ctldwbtmdtpuygfj")
    public suspend fun bitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value The number of channels in the audio.
     */
    @JvmName("bvwwvkoikisvrtxp")
    public suspend fun channels(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channels = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("vycwaqcafbivrymh")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.DDAudio'.
     */
    @JvmName("wnslvjnmxasfkivi")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The sampling rate to use for encoding in hertz.
     */
    @JvmName("vunjcmfcsmrqhfbj")
    public suspend fun samplingRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingRate = mapped
    }

    internal fun build(): DDAudioArgs = DDAudioArgs(
        bitrate = bitrate,
        channels = channels,
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        samplingRate = samplingRate,
    )
}
