@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FaceDetectorPresetArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AnalysisResolution
import com.pulumi.azurenative.media.kotlin.enums.BlurType
import com.pulumi.azurenative.media.kotlin.enums.FaceRedactorMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.
 * @property blurType Blur type
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property mode This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.FaceDetectorPreset'.
 * @property resolution Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
 */
public data class FaceDetectorPresetArgs(
    public val blurType: Output<Either<String, BlurType>>? = null,
    public val experimentalOptions: Output<Map<String, String>>? = null,
    public val mode: Output<Either<String, FaceRedactorMode>>? = null,
    public val odataType: Output<String>,
    public val resolution: Output<Either<String, AnalysisResolution>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FaceDetectorPresetArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FaceDetectorPresetArgs =
        com.pulumi.azurenative.media.inputs.FaceDetectorPresetArgs.builder()
            .blurType(
                blurType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .experimentalOptions(
                experimentalOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .resolution(
                resolution?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FaceDetectorPresetArgs].
 */
@PulumiTagMarker
public class FaceDetectorPresetArgsBuilder internal constructor() {
    private var blurType: Output<Either<String, BlurType>>? = null

    private var experimentalOptions: Output<Map<String, String>>? = null

    private var mode: Output<Either<String, FaceRedactorMode>>? = null

    private var odataType: Output<String>? = null

    private var resolution: Output<Either<String, AnalysisResolution>>? = null

    /**
     * @param value Blur type
     */
    @JvmName("wnjatkpjbvxivuig")
    public suspend fun blurType(`value`: Output<Either<String, BlurType>>) {
        this.blurType = value
    }

    /**
     * @param value Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("cnqhjtkpapqspwfh")
    public suspend fun experimentalOptions(`value`: Output<Map<String, String>>) {
        this.experimentalOptions = value
    }

    /**
     * @param value This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
     */
    @JvmName("elkrkfxmoykehwxl")
    public suspend fun mode(`value`: Output<Either<String, FaceRedactorMode>>) {
        this.mode = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.FaceDetectorPreset'.
     */
    @JvmName("kwiapwxctcaqhnur")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
     */
    @JvmName("fvttknmxcphhqotk")
    public suspend fun resolution(`value`: Output<Either<String, AnalysisResolution>>) {
        this.resolution = value
    }

    /**
     * @param value Blur type
     */
    @JvmName("tobsadkspavyyyha")
    public suspend fun blurType(`value`: Either<String, BlurType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blurType = mapped
    }

    /**
     * @param value Blur type
     */
    @JvmName("fxkrtfovdxjigfhj")
    public fun blurType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BlurType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blurType = mapped
    }

    /**
     * @param value Blur type
     */
    @JvmName("lbqmyioraoymtrac")
    public fun blurType(`value`: BlurType) {
        val toBeMapped = Either.ofRight<String, BlurType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blurType = mapped
    }

    /**
     * @param value Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("essbajxorossaocb")
    public suspend fun experimentalOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentalOptions = mapped
    }

    /**
     * @param values Dictionary containing key value pairs for parameters not exposed in the preset itself
     */
    @JvmName("vpahvycsxtlsorgl")
    public fun experimentalOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.experimentalOptions = mapped
    }

    /**
     * @param value This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
     */
    @JvmName("hpycycjdaoyipnnu")
    public suspend fun mode(`value`: Either<String, FaceRedactorMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
     */
    @JvmName("uyspepcayjotiwqw")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FaceRedactorMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
     */
    @JvmName("qgenweivkehuvknf")
    public fun mode(`value`: FaceRedactorMode) {
        val toBeMapped = Either.ofRight<String, FaceRedactorMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.FaceDetectorPreset'.
     */
    @JvmName("osdqsoralyuomqhe")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
     */
    @JvmName("petimxhqkrugymgg")
    public suspend fun resolution(`value`: Either<String, AnalysisResolution>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolution = mapped
    }

    /**
     * @param value Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
     */
    @JvmName("dnyuvxaeyuifniuy")
    public fun resolution(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AnalysisResolution>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resolution = mapped
    }

    /**
     * @param value Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
     */
    @JvmName("cdghagehermdabkx")
    public fun resolution(`value`: AnalysisResolution) {
        val toBeMapped = Either.ofRight<String, AnalysisResolution>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resolution = mapped
    }

    internal fun build(): FaceDetectorPresetArgs = FaceDetectorPresetArgs(
        blurType = blurType,
        experimentalOptions = experimentalOptions,
        mode = mode,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        resolution = resolution,
    )
}
