@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetAssetFilterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property assetName The Asset name.
 * @property filterName The Asset Filter name
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetAssetFilterPlainArgs(
    public val accountName: String,
    public val assetName: String,
    public val filterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetAssetFilterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetAssetFilterPlainArgs =
        com.pulumi.azurenative.media.inputs.GetAssetFilterPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .assetName(assetName.let({ args0 -> args0 }))
            .filterName(filterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssetFilterPlainArgs].
 */
@PulumiTagMarker
public class GetAssetFilterPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var assetName: String? = null

    private var filterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("smwneswedsycqkhe")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("kupiupppfmppxwwp")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetName = mapped
    }

    /**
     * @param value The Asset Filter name
     */
    @JvmName("dsackursdcxyqcmn")
    public suspend fun filterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filterName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("klyqfcxnitqfhfvg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssetFilterPlainArgs = GetAssetFilterPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        filterName = filterName ?: throw PulumiNullFieldException("filterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
