@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetTrackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property assetName The Asset name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property trackName The Asset Track name.
 */
public data class GetTrackPlainArgs(
    public val accountName: String,
    public val assetName: String,
    public val resourceGroupName: String,
    public val trackName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetTrackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetTrackPlainArgs =
        com.pulumi.azurenative.media.inputs.GetTrackPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .assetName(assetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .trackName(trackName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrackPlainArgs].
 */
@PulumiTagMarker
public class GetTrackPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var assetName: String? = null

    private var resourceGroupName: String? = null

    private var trackName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("iplgxcmpwmylfutv")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("rbslefqosvndjlwx")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("pfeebgnssygqkfcq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Asset Track name.
     */
    @JvmName("hqanqhttdxqddxix")
    public suspend fun trackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trackName = mapped
    }

    internal fun build(): GetTrackPlainArgs = GetTrackPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        trackName = trackName ?: throw PulumiNullFieldException("trackName"),
    )
}
