@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetTransformPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property transformName The Transform name.
 */
public data class GetTransformPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val transformName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetTransformPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetTransformPlainArgs =
        com.pulumi.azurenative.media.inputs.GetTransformPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .transformName(transformName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransformPlainArgs].
 */
@PulumiTagMarker
public class GetTransformPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var transformName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("pektcpfmtrjkaypm")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("jgtnsiowalpxatbt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Transform name.
     */
    @JvmName("dclhwcqvvshnuhgd")
    public suspend fun transformName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transformName = mapped
    }

    internal fun build(): GetTransformPlainArgs = GetTransformPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        transformName = transformName ?: throw PulumiNullFieldException("transformName"),
    )
}
