@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.H265VideoArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.H265Complexity
import com.pulumi.azurenative.media.kotlin.enums.StretchMode
import com.pulumi.azurenative.media.kotlin.enums.VideoSyncMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes all the properties for encoding a video with the H.265 codec.
 * @property complexity Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property layers The collection of output H.265 layers to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.H265Video'.
 * @property sceneChangeDetection Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class H265VideoArgs(
    public val complexity: Output<Either<String, H265Complexity>>? = null,
    public val keyFrameInterval: Output<String>? = null,
    public val label: Output<String>? = null,
    public val layers: Output<List<H265LayerArgs>>? = null,
    public val odataType: Output<String>,
    public val sceneChangeDetection: Output<Boolean>? = null,
    public val stretchMode: Output<Either<String, StretchMode>>? = null,
    public val syncMode: Output<Either<String, VideoSyncMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.H265VideoArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.H265VideoArgs =
        com.pulumi.azurenative.media.inputs.H265VideoArgs.builder()
            .complexity(
                complexity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyFrameInterval(keyFrameInterval?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .sceneChangeDetection(sceneChangeDetection?.applyValue({ args0 -> args0 }))
            .stretchMode(
                stretchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncMode(
                syncMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [H265VideoArgs].
 */
@PulumiTagMarker
public class H265VideoArgsBuilder internal constructor() {
    private var complexity: Output<Either<String, H265Complexity>>? = null

    private var keyFrameInterval: Output<String>? = null

    private var label: Output<String>? = null

    private var layers: Output<List<H265LayerArgs>>? = null

    private var odataType: Output<String>? = null

    private var sceneChangeDetection: Output<Boolean>? = null

    private var stretchMode: Output<Either<String, StretchMode>>? = null

    private var syncMode: Output<Either<String, VideoSyncMode>>? = null

    /**
     * @param value Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
     */
    @JvmName("cyeiuelfajckdttj")
    public suspend fun complexity(`value`: Output<Either<String, H265Complexity>>) {
        this.complexity = value
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("rwprfvwcjvteqnnv")
    public suspend fun keyFrameInterval(`value`: Output<String>) {
        this.keyFrameInterval = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("mfiqmfjklsvodvex")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("qyocropxbrsheldd")
    public suspend fun layers(`value`: Output<List<H265LayerArgs>>) {
        this.layers = value
    }

    @JvmName("yuvvxjwfbmtuhlaj")
    public suspend fun layers(vararg values: Output<H265LayerArgs>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("smljdgbvufbqiaxe")
    public suspend fun layers(values: List<Output<H265LayerArgs>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.H265Video'.
     */
    @JvmName("xheweegkyinhdoxd")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
     */
    @JvmName("tawxlgvwqrqjlvun")
    public suspend fun sceneChangeDetection(`value`: Output<Boolean>) {
        this.sceneChangeDetection = value
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("gbcixrgqqnqoexjt")
    public suspend fun stretchMode(`value`: Output<Either<String, StretchMode>>) {
        this.stretchMode = value
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("uuydsihudoelbyvt")
    public suspend fun syncMode(`value`: Output<Either<String, VideoSyncMode>>) {
        this.syncMode = value
    }

    /**
     * @param value Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
     */
    @JvmName("cppffbbcwyrxnvil")
    public suspend fun complexity(`value`: Either<String, H265Complexity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
     */
    @JvmName("neiosmjkcfsubylc")
    public fun complexity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, H265Complexity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
     */
    @JvmName("nynjksvgyrvvmryo")
    public fun complexity(`value`: H265Complexity) {
        val toBeMapped = Either.ofRight<String, H265Complexity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("quxjiplceupboaqe")
    public suspend fun keyFrameInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameInterval = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("xrrqedrrolwqovrm")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("ygljjeirlyilrocx")
    public suspend fun layers(`value`: List<H265LayerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param argument The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("agrqomgqwxparbrq")
    public suspend fun layers(argument: List<suspend H265LayerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { H265LayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("muneuqchrjhjtcqp")
    public suspend fun layers(vararg argument: suspend H265LayerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { H265LayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("lwbbqcuxehglntdu")
    public suspend fun layers(argument: suspend H265LayerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(H265LayerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param values The collection of output H.265 layers to be produced by the encoder.
     */
    @JvmName("kavajosdiipbhmfc")
    public suspend fun layers(vararg values: H265LayerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.H265Video'.
     */
    @JvmName("koatldyfjgiisxgi")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
     */
    @JvmName("hnmwmbibdwixwksg")
    public suspend fun sceneChangeDetection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sceneChangeDetection = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("qlokosvaqeqphnoo")
    public suspend fun stretchMode(`value`: Either<String, StretchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("bxgpsksrjqlmhihu")
    public fun stretchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("jwsywbvsgtvfaijc")
    public fun stretchMode(`value`: StretchMode) {
        val toBeMapped = Either.ofRight<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("jxkqgfuyatdpamka")
    public suspend fun syncMode(`value`: Either<String, VideoSyncMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("cgijgdgbhsxggfok")
    public fun syncMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("ofuckmffvnqugisk")
    public fun syncMode(`value`: VideoSyncMode) {
        val toBeMapped = Either.ofRight<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    internal fun build(): H265VideoArgs = H265VideoArgs(
        complexity = complexity,
        keyFrameInterval = keyFrameInterval,
        label = label,
        layers = layers,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        sceneChangeDetection = sceneChangeDetection,
        stretchMode = stretchMode,
        syncMode = syncMode,
    )
}
