@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.HlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HTTP Live Streaming (HLS) packing setting for the live output.
 * @property fragmentsPerTsSegment The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
 */
public data class HlsArgs(
    public val fragmentsPerTsSegment: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.HlsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.HlsArgs =
        com.pulumi.azurenative.media.inputs.HlsArgs.builder()
            .fragmentsPerTsSegment(fragmentsPerTsSegment?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HlsArgs].
 */
@PulumiTagMarker
public class HlsArgsBuilder internal constructor() {
    private var fragmentsPerTsSegment: Output<Int>? = null

    /**
     * @param value The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
     */
    @JvmName("kxcknclrvvwriuqi")
    public suspend fun fragmentsPerTsSegment(`value`: Output<Int>) {
        this.fragmentsPerTsSegment = value
    }

    /**
     * @param value The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
     */
    @JvmName("koxmqmsbmvfwnowj")
    public suspend fun fragmentsPerTsSegment(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fragmentsPerTsSegment = mapped
    }

    internal fun build(): HlsArgs = HlsArgs(
        fragmentsPerTsSegment = fragmentsPerTsSegment,
    )
}
