@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.JobInputSequenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.
 * @property inputs JobInputs that make up the timeline.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobInputSequence'.
 */
public data class JobInputSequenceArgs(
    public val inputs: Output<List<JobInputClipArgs>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.JobInputSequenceArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.JobInputSequenceArgs =
        com.pulumi.azurenative.media.inputs.JobInputSequenceArgs.builder()
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobInputSequenceArgs].
 */
@PulumiTagMarker
public class JobInputSequenceArgsBuilder internal constructor() {
    private var inputs: Output<List<JobInputClipArgs>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value JobInputs that make up the timeline.
     */
    @JvmName("vmacumkjyoktdgij")
    public suspend fun inputs(`value`: Output<List<JobInputClipArgs>>) {
        this.inputs = value
    }

    @JvmName("qswuyiloobjxwbdj")
    public suspend fun inputs(vararg values: Output<JobInputClipArgs>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values JobInputs that make up the timeline.
     */
    @JvmName("oeyhrtpscrwafodw")
    public suspend fun inputs(values: List<Output<JobInputClipArgs>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JobInputSequence'.
     */
    @JvmName("ijhpqshlmrprfwtt")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value JobInputs that make up the timeline.
     */
    @JvmName("btritaprcmlmhdek")
    public suspend fun inputs(`value`: List<JobInputClipArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument JobInputs that make up the timeline.
     */
    @JvmName("mkmcddpdtukqjgxx")
    public suspend fun inputs(argument: List<suspend JobInputClipArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobInputClipArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument JobInputs that make up the timeline.
     */
    @JvmName("mmpinkyovayrqsov")
    public suspend fun inputs(vararg argument: suspend JobInputClipArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobInputClipArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument JobInputs that make up the timeline.
     */
    @JvmName("ikybrvhvsxtqqwws")
    public suspend fun inputs(argument: suspend JobInputClipArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JobInputClipArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param values JobInputs that make up the timeline.
     */
    @JvmName("ofrgwwvqgesfaxuu")
    public suspend fun inputs(vararg values: JobInputClipArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JobInputSequence'.
     */
    @JvmName("duxplbadgdccfgou")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): JobInputSequenceArgs = JobInputSequenceArgs(
        inputs = inputs,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
