@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ListMediaServiceEdgePoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property deviceId Unique identifier of the edge device.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class ListMediaServiceEdgePoliciesPlainArgs(
    public val accountName: String,
    public val deviceId: String? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ListMediaServiceEdgePoliciesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ListMediaServiceEdgePoliciesPlainArgs =
        com.pulumi.azurenative.media.inputs.ListMediaServiceEdgePoliciesPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .deviceId(deviceId?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMediaServiceEdgePoliciesPlainArgs].
 */
@PulumiTagMarker
public class ListMediaServiceEdgePoliciesPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var deviceId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("afqqxqbfanfqqgxl")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Unique identifier of the edge device.
     */
    @JvmName("psckuqicmdoyxslm")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deviceId = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("cwkcqiccvpuolfre")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMediaServiceEdgePoliciesPlainArgs =
        ListMediaServiceEdgePoliciesPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            deviceId = deviceId,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
