@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The live event endpoint.
 * @property protocol The endpoint protocol.
 * @property url The endpoint URL.
 */
public data class LiveEventEndpointArgs(
    public val protocol: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventEndpointArgs =
        com.pulumi.azurenative.media.inputs.LiveEventEndpointArgs.builder()
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveEventEndpointArgs].
 */
@PulumiTagMarker
public class LiveEventEndpointArgsBuilder internal constructor() {
    private var protocol: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The endpoint protocol.
     */
    @JvmName("vfbqidmavaroyvys")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The endpoint URL.
     */
    @JvmName("qkrrnehycskklawp")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The endpoint protocol.
     */
    @JvmName("fkwxkvcrqdqdfvbr")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The endpoint URL.
     */
    @JvmName("xddrtcfdvjmlbnxl")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): LiveEventEndpointArgs = LiveEventEndpointArgs(
        protocol = protocol,
        url = url,
    )
}
