@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventInputArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.LiveEventInputProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The live event input.
 * @property accessControl Access control for live event input.
 * @property accessToken A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
 * @property endpoints The input endpoints for the live event.
 * @property keyFrameIntervalDuration ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
 * @property streamingProtocol The input protocol for the live event. This is specified at creation time and cannot be updated.
 * @property timedMetadataEndpoints The metadata endpoints for the live event.
 */
public data class LiveEventInputArgs(
    public val accessControl: Output<LiveEventInputAccessControlArgs>? = null,
    public val accessToken: Output<String>? = null,
    public val endpoints: Output<List<LiveEventEndpointArgs>>? = null,
    public val keyFrameIntervalDuration: Output<String>? = null,
    public val streamingProtocol: Output<Either<String, LiveEventInputProtocol>>,
    public val timedMetadataEndpoints: Output<List<LiveEventTimedMetadataEndpointArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventInputArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventInputArgs =
        com.pulumi.azurenative.media.inputs.LiveEventInputArgs.builder()
            .accessControl(accessControl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .keyFrameIntervalDuration(keyFrameIntervalDuration?.applyValue({ args0 -> args0 }))
            .streamingProtocol(
                streamingProtocol.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .timedMetadataEndpoints(
                timedMetadataEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LiveEventInputArgs].
 */
@PulumiTagMarker
public class LiveEventInputArgsBuilder internal constructor() {
    private var accessControl: Output<LiveEventInputAccessControlArgs>? = null

    private var accessToken: Output<String>? = null

    private var endpoints: Output<List<LiveEventEndpointArgs>>? = null

    private var keyFrameIntervalDuration: Output<String>? = null

    private var streamingProtocol: Output<Either<String, LiveEventInputProtocol>>? = null

    private var timedMetadataEndpoints: Output<List<LiveEventTimedMetadataEndpointArgs>>? = null

    /**
     * @param value Access control for live event input.
     */
    @JvmName("ffiwwevhugcegchm")
    public suspend fun accessControl(`value`: Output<LiveEventInputAccessControlArgs>) {
        this.accessControl = value
    }

    /**
     * @param value A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
     */
    @JvmName("htjpnypnsrqhxqco")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value The input endpoints for the live event.
     */
    @JvmName("srphbwbaebascuky")
    public suspend fun endpoints(`value`: Output<List<LiveEventEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("yqmlnxjbpyowglks")
    public suspend fun endpoints(vararg values: Output<LiveEventEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values The input endpoints for the live event.
     */
    @JvmName("vgxiqgmwfvyaulha")
    public suspend fun endpoints(values: List<Output<LiveEventEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
     */
    @JvmName("iduursbwciygmukd")
    public suspend fun keyFrameIntervalDuration(`value`: Output<String>) {
        this.keyFrameIntervalDuration = value
    }

    /**
     * @param value The input protocol for the live event. This is specified at creation time and cannot be updated.
     */
    @JvmName("igputamgqjbkilua")
    public suspend fun streamingProtocol(`value`: Output<Either<String, LiveEventInputProtocol>>) {
        this.streamingProtocol = value
    }

    /**
     * @param value The metadata endpoints for the live event.
     */
    @JvmName("jmknbapjrshlravu")
    public suspend
    fun timedMetadataEndpoints(`value`: Output<List<LiveEventTimedMetadataEndpointArgs>>) {
        this.timedMetadataEndpoints = value
    }

    @JvmName("deqjqaveuadqfjwe")
    public suspend fun timedMetadataEndpoints(
        vararg
        values: Output<LiveEventTimedMetadataEndpointArgs>,
    ) {
        this.timedMetadataEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The metadata endpoints for the live event.
     */
    @JvmName("rvtqevrhupiufvcq")
    public suspend
    fun timedMetadataEndpoints(values: List<Output<LiveEventTimedMetadataEndpointArgs>>) {
        this.timedMetadataEndpoints = Output.all(values)
    }

    /**
     * @param value Access control for live event input.
     */
    @JvmName("xfycvhjcfnhjnuhq")
    public suspend fun accessControl(`value`: LiveEventInputAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControl = mapped
    }

    /**
     * @param argument Access control for live event input.
     */
    @JvmName("smnhijbcfvdplxpi")
    public suspend
    fun accessControl(argument: suspend LiveEventInputAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = LiveEventInputAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessControl = mapped
    }

    /**
     * @param value A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
     */
    @JvmName("gipfbfyufblmsaiu")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The input endpoints for the live event.
     */
    @JvmName("nejlnyxyabuonntw")
    public suspend fun endpoints(`value`: List<LiveEventEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument The input endpoints for the live event.
     */
    @JvmName("fajxiyevpgstbdda")
    public suspend fun endpoints(argument: List<suspend LiveEventEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LiveEventEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The input endpoints for the live event.
     */
    @JvmName("xkvgndgtwortwwkf")
    public suspend fun endpoints(vararg argument: suspend LiveEventEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LiveEventEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The input endpoints for the live event.
     */
    @JvmName("efdsdnldwibywjsh")
    public suspend fun endpoints(argument: suspend LiveEventEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LiveEventEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values The input endpoints for the live event.
     */
    @JvmName("rwmglfacftgfyupq")
    public suspend fun endpoints(vararg values: LiveEventEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
     */
    @JvmName("ybdvxbkehoyxnywi")
    public suspend fun keyFrameIntervalDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameIntervalDuration = mapped
    }

    /**
     * @param value The input protocol for the live event. This is specified at creation time and cannot be updated.
     */
    @JvmName("vgccdvjloyqphqmx")
    public suspend fun streamingProtocol(`value`: Either<String, LiveEventInputProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamingProtocol = mapped
    }

    /**
     * @param value The input protocol for the live event. This is specified at creation time and cannot be updated.
     */
    @JvmName("wlrdqmouthshxoix")
    public fun streamingProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LiveEventInputProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamingProtocol = mapped
    }

    /**
     * @param value The input protocol for the live event. This is specified at creation time and cannot be updated.
     */
    @JvmName("syiisfvcdidjitfd")
    public fun streamingProtocol(`value`: LiveEventInputProtocol) {
        val toBeMapped = Either.ofRight<String, LiveEventInputProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamingProtocol = mapped
    }

    /**
     * @param value The metadata endpoints for the live event.
     */
    @JvmName("vugbhpdrihfqkydj")
    public suspend fun timedMetadataEndpoints(`value`: List<LiveEventTimedMetadataEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataEndpoints = mapped
    }

    /**
     * @param argument The metadata endpoints for the live event.
     */
    @JvmName("smlhhojlrniljcel")
    public suspend
    fun timedMetadataEndpoints(argument: List<suspend LiveEventTimedMetadataEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LiveEventTimedMetadataEndpointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.timedMetadataEndpoints = mapped
    }

    /**
     * @param argument The metadata endpoints for the live event.
     */
    @JvmName("umxuympxtkpkhkrh")
    public suspend fun timedMetadataEndpoints(
        vararg
        argument: suspend LiveEventTimedMetadataEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LiveEventTimedMetadataEndpointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.timedMetadataEndpoints = mapped
    }

    /**
     * @param argument The metadata endpoints for the live event.
     */
    @JvmName("qtwohjnkbbnewtyh")
    public suspend
    fun timedMetadataEndpoints(argument: suspend LiveEventTimedMetadataEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LiveEventTimedMetadataEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.timedMetadataEndpoints = mapped
    }

    /**
     * @param values The metadata endpoints for the live event.
     */
    @JvmName("amlligccortbgrei")
    public suspend fun timedMetadataEndpoints(vararg values: LiveEventTimedMetadataEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timedMetadataEndpoints = mapped
    }

    internal fun build(): LiveEventInputArgs = LiveEventInputArgs(
        accessControl = accessControl,
        accessToken = accessToken,
        endpoints = endpoints,
        keyFrameIntervalDuration = keyFrameIntervalDuration,
        streamingProtocol = streamingProtocol ?: throw PulumiNullFieldException("streamingProtocol"),
        timedMetadataEndpoints = timedMetadataEndpoints,
    )
}
