@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventInputTrackSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
 * @property operation Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
 * @property property Property name to select. This property is reserved for future use, any value set on this property will be ignored.
 * @property value Property value to select. This property is reserved for future use, any value set on this property will be ignored.
 */
public data class LiveEventInputTrackSelectionArgs(
    public val operation: Output<String>? = null,
    public val `property`: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventInputTrackSelectionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventInputTrackSelectionArgs =
        com.pulumi.azurenative.media.inputs.LiveEventInputTrackSelectionArgs.builder()
            .operation(operation?.applyValue({ args0 -> args0 }))
            .`property`(`property`?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveEventInputTrackSelectionArgs].
 */
@PulumiTagMarker
public class LiveEventInputTrackSelectionArgsBuilder internal constructor() {
    private var operation: Output<String>? = null

    private var `property`: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("mukrjywydrxfbtnh")
    public suspend fun operation(`value`: Output<String>) {
        this.operation = value
    }

    /**
     * @param value Property name to select. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("bsvlhjuiisncvcof")
    public suspend fun `property`(`value`: Output<String>) {
        this.`property` = value
    }

    /**
     * @param value Property value to select. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("dypkoqtscsgtbmvv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("kmomiuklljaaqwpj")
    public suspend fun operation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value Property name to select. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("iueijllcgmbmnvqu")
    public suspend fun `property`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value Property value to select. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("pytisrhigfwaytnp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): LiveEventInputTrackSelectionArgs = LiveEventInputTrackSelectionArgs(
        operation = operation,
        `property` = `property`,
        `value` = `value`,
    )
}
