@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventTranscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
 * @property inputTrackSelection Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
 * @property language Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
 * @property outputTranscriptionTrack Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
 */
public data class LiveEventTranscriptionArgs(
    public val inputTrackSelection: Output<List<LiveEventInputTrackSelectionArgs>>? = null,
    public val language: Output<String>? = null,
    public val outputTranscriptionTrack: Output<LiveEventOutputTranscriptionTrackArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventTranscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventTranscriptionArgs =
        com.pulumi.azurenative.media.inputs.LiveEventTranscriptionArgs.builder()
            .inputTrackSelection(
                inputTrackSelection?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .language(language?.applyValue({ args0 -> args0 }))
            .outputTranscriptionTrack(
                outputTranscriptionTrack?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LiveEventTranscriptionArgs].
 */
@PulumiTagMarker
public class LiveEventTranscriptionArgsBuilder internal constructor() {
    private var inputTrackSelection: Output<List<LiveEventInputTrackSelectionArgs>>? = null

    private var language: Output<String>? = null

    private var outputTranscriptionTrack: Output<LiveEventOutputTranscriptionTrackArgs>? = null

    /**
     * @param value Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("eayfxogkasxmilux")
    public suspend fun inputTrackSelection(`value`: Output<List<LiveEventInputTrackSelectionArgs>>) {
        this.inputTrackSelection = value
    }

    @JvmName("jcxiennlshnphyjj")
    public suspend fun inputTrackSelection(vararg values: Output<LiveEventInputTrackSelectionArgs>) {
        this.inputTrackSelection = Output.all(values.asList())
    }

    /**
     * @param values Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("toidybniwfluqwfa")
    public suspend fun inputTrackSelection(values: List<Output<LiveEventInputTrackSelectionArgs>>) {
        this.inputTrackSelection = Output.all(values)
    }

    /**
     * @param value Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
     */
    @JvmName("pvpshrosqfkthgtq")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("bsyhehhbuamlidve")
    public suspend
    fun outputTranscriptionTrack(`value`: Output<LiveEventOutputTranscriptionTrackArgs>) {
        this.outputTranscriptionTrack = value
    }

    /**
     * @param value Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("qihueysmkhuqbiwu")
    public suspend fun inputTrackSelection(`value`: List<LiveEventInputTrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputTrackSelection = mapped
    }

    /**
     * @param argument Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("jfahsyfddtglngqb")
    public suspend
    fun inputTrackSelection(argument: List<suspend LiveEventInputTrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LiveEventInputTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputTrackSelection = mapped
    }

    /**
     * @param argument Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("laheevknkrtvwdjs")
    public suspend fun inputTrackSelection(
        vararg
        argument: suspend LiveEventInputTrackSelectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LiveEventInputTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputTrackSelection = mapped
    }

    /**
     * @param argument Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("kiwjetbhrmgsgowi")
    public suspend
    fun inputTrackSelection(argument: suspend LiveEventInputTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LiveEventInputTrackSelectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputTrackSelection = mapped
    }

    /**
     * @param values Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("fsuwbrjnhmbuattf")
    public suspend fun inputTrackSelection(vararg values: LiveEventInputTrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputTrackSelection = mapped
    }

    /**
     * @param value Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
     */
    @JvmName("nrnnfohrebrmgcrh")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("gfnaimlkxfgdmyds")
    public suspend fun outputTranscriptionTrack(`value`: LiveEventOutputTranscriptionTrackArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputTranscriptionTrack = mapped
    }

    /**
     * @param argument Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("udatqbfbqekexjae")
    public suspend
    fun outputTranscriptionTrack(argument: suspend LiveEventOutputTranscriptionTrackArgsBuilder.() -> Unit) {
        val toBeMapped = LiveEventOutputTranscriptionTrackArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outputTranscriptionTrack = mapped
    }

    internal fun build(): LiveEventTranscriptionArgs = LiveEventTranscriptionArgs(
        inputTrackSelection = inputTrackSelection,
        language = language,
        outputTranscriptionTrack = outputTranscriptionTrack,
    )
}
