@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Asset sink.
 * @property assetName Asset name.
 * @property inputs Sink inputs.
 * @property name Sink name.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphAssetSink'.
 */
public data class MediaGraphAssetSinkArgs(
    public val assetName: Output<String>,
    public val inputs: Output<List<String>>,
    public val name: Output<String>,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs.builder()
            .assetName(assetName.applyValue({ args0 -> args0 }))
            .inputs(inputs.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaGraphAssetSinkArgs].
 */
@PulumiTagMarker
public class MediaGraphAssetSinkArgsBuilder internal constructor() {
    private var assetName: Output<String>? = null

    private var inputs: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value Asset name.
     */
    @JvmName("mvbbbpgkalstrdvy")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value Sink inputs.
     */
    @JvmName("ihwitstklkeksmvv")
    public suspend fun inputs(`value`: Output<List<String>>) {
        this.inputs = value
    }

    @JvmName("eoccjqgvxxayrqjj")
    public suspend fun inputs(vararg values: Output<String>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values Sink inputs.
     */
    @JvmName("llptpwgerjagigqh")
    public suspend fun inputs(values: List<Output<String>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value Sink name.
     */
    @JvmName("fmubwfvovblugmxo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphAssetSink'.
     */
    @JvmName("scvjqwlwjojpoqni")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Asset name.
     */
    @JvmName("diasmqfcgvolggjb")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value Sink inputs.
     */
    @JvmName("paadglhkldpfkhjo")
    public suspend fun inputs(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values Sink inputs.
     */
    @JvmName("hssxucdmvtrldoav")
    public suspend fun inputs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Sink name.
     */
    @JvmName("ofycjxdnheptuhvm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphAssetSink'.
     */
    @JvmName("uofknyqyvqbtpuod")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): MediaGraphAssetSinkArgs = MediaGraphAssetSinkArgs(
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        inputs = inputs ?: throw PulumiNullFieldException("inputs"),
        name = name ?: throw PulumiNullFieldException("name"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
