@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphClearEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An endpoint to connect to with no encryption in transit.
 * @property credentials Polymorphic credentials to present to the endpoint.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphClearEndpoint'.
 * @property url Url for the endpoint.
 */
public data class MediaGraphClearEndpointArgs(
    public val credentials: Output<MediaGraphUsernamePasswordCredentialsArgs>? = null,
    public val odataType: Output<String>,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphClearEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaGraphClearEndpointArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphClearEndpointArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaGraphClearEndpointArgs].
 */
@PulumiTagMarker
public class MediaGraphClearEndpointArgsBuilder internal constructor() {
    private var credentials: Output<MediaGraphUsernamePasswordCredentialsArgs>? = null

    private var odataType: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value Polymorphic credentials to present to the endpoint.
     */
    @JvmName("amldxkrceuqvbwep")
    public suspend fun credentials(`value`: Output<MediaGraphUsernamePasswordCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphClearEndpoint'.
     */
    @JvmName("gqitkdgklwikgtdi")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Url for the endpoint.
     */
    @JvmName("dtxeynhndywwccju")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Polymorphic credentials to present to the endpoint.
     */
    @JvmName("noylmdbvgveaaqjl")
    public suspend fun credentials(`value`: MediaGraphUsernamePasswordCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Polymorphic credentials to present to the endpoint.
     */
    @JvmName("ekfykldgwtrncmmf")
    public suspend
    fun credentials(argument: suspend MediaGraphUsernamePasswordCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = MediaGraphUsernamePasswordCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphClearEndpoint'.
     */
    @JvmName("opqbioiidcqdnqwh")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Url for the endpoint.
     */
    @JvmName("wttqpxrlxrhvnyxj")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): MediaGraphClearEndpointArgs = MediaGraphClearEndpointArgs(
        credentials = credentials,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
