@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphTlsValidationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Options for controlling the authentication of TLS endpoints.
 * @property ignoreHostname Ignore the host name (common name) during validation.
 * @property ignoreSignature Ignore the integrity of the certificate chain at the current time.
 */
public data class MediaGraphTlsValidationOptionsArgs(
    public val ignoreHostname: Output<Boolean>,
    public val ignoreSignature: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphTlsValidationOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaGraphTlsValidationOptionsArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphTlsValidationOptionsArgs.builder()
            .ignoreHostname(ignoreHostname.applyValue({ args0 -> args0 }))
            .ignoreSignature(ignoreSignature.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaGraphTlsValidationOptionsArgs].
 */
@PulumiTagMarker
public class MediaGraphTlsValidationOptionsArgsBuilder internal constructor() {
    private var ignoreHostname: Output<Boolean>? = null

    private var ignoreSignature: Output<Boolean>? = null

    /**
     * @param value Ignore the host name (common name) during validation.
     */
    @JvmName("lqpoxvpobpdmnsxm")
    public suspend fun ignoreHostname(`value`: Output<Boolean>) {
        this.ignoreHostname = value
    }

    /**
     * @param value Ignore the integrity of the certificate chain at the current time.
     */
    @JvmName("mtyeesrxhwufskwr")
    public suspend fun ignoreSignature(`value`: Output<Boolean>) {
        this.ignoreSignature = value
    }

    /**
     * @param value Ignore the host name (common name) during validation.
     */
    @JvmName("ekpehlcrktvrwukx")
    public suspend fun ignoreHostname(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ignoreHostname = mapped
    }

    /**
     * @param value Ignore the integrity of the certificate chain at the current time.
     */
    @JvmName("alsxxxrtnjygxuec")
    public suspend fun ignoreSignature(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ignoreSignature = mapped
    }

    internal fun build(): MediaGraphTlsValidationOptionsArgs = MediaGraphTlsValidationOptionsArgs(
        ignoreHostname = ignoreHostname ?: throw PulumiNullFieldException("ignoreHostname"),
        ignoreSignature = ignoreSignature ?: throw PulumiNullFieldException("ignoreSignature"),
    )
}
