@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.NoEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for NoEncryption scheme
 * @property enabledProtocols Representing supported protocols
 */
public data class NoEncryptionArgs(
    public val enabledProtocols: Output<EnabledProtocolsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.NoEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.NoEncryptionArgs =
        com.pulumi.azurenative.media.inputs.NoEncryptionArgs.builder()
            .enabledProtocols(
                enabledProtocols?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NoEncryptionArgs].
 */
@PulumiTagMarker
public class NoEncryptionArgsBuilder internal constructor() {
    private var enabledProtocols: Output<EnabledProtocolsArgs>? = null

    /**
     * @param value Representing supported protocols
     */
    @JvmName("gyqpwfhodkdfenau")
    public suspend fun enabledProtocols(`value`: Output<EnabledProtocolsArgs>) {
        this.enabledProtocols = value
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("omboocnvfgjrorey")
    public suspend fun enabledProtocols(`value`: EnabledProtocolsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param argument Representing supported protocols
     */
    @JvmName("neaggwykwruecfkf")
    public suspend fun enabledProtocols(argument: suspend EnabledProtocolsArgsBuilder.() -> Unit) {
        val toBeMapped = EnabledProtocolsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enabledProtocols = mapped
    }

    internal fun build(): NoEncryptionArgs = NoEncryptionArgs(
        enabledProtocols = enabledProtocols,
    )
}
