@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.PngFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the settings for producing PNG thumbnails.
 * @property filenamePattern The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.PngFormat'.
 */
public data class PngFormatArgs(
    public val filenamePattern: Output<String>,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.PngFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.PngFormatArgs =
        com.pulumi.azurenative.media.inputs.PngFormatArgs.builder()
            .filenamePattern(filenamePattern.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PngFormatArgs].
 */
@PulumiTagMarker
public class PngFormatArgsBuilder internal constructor() {
    private var filenamePattern: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
     */
    @JvmName("iycbyejsxlnjjhpw")
    public suspend fun filenamePattern(`value`: Output<String>) {
        this.filenamePattern = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.PngFormat'.
     */
    @JvmName("fmhlqrkvohmieimd")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
     */
    @JvmName("gpjcvleobowialsb")
    public suspend fun filenamePattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filenamePattern = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.PngFormat'.
     */
    @JvmName("abkunjfgsyrfgeia")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): PngFormatArgs = PngFormatArgs(
        filenamePattern = filenamePattern ?: throw PulumiNullFieldException("filenamePattern"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
