@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.PresentationTimeRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The presentation time range, this is asset related and not recommended for Account Filter.
 * @property endTimestamp The absolute end time boundary.
 * @property forceEndTimestamp The indicator of forcing existing of end time stamp.
 * @property liveBackoffDuration The relative to end right edge.
 * @property presentationWindowDuration The relative to end sliding window.
 * @property startTimestamp The absolute start time boundary.
 * @property timescale The time scale of time stamps.
 */
public data class PresentationTimeRangeArgs(
    public val endTimestamp: Output<Double>? = null,
    public val forceEndTimestamp: Output<Boolean>? = null,
    public val liveBackoffDuration: Output<Double>? = null,
    public val presentationWindowDuration: Output<Double>? = null,
    public val startTimestamp: Output<Double>? = null,
    public val timescale: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.PresentationTimeRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.PresentationTimeRangeArgs =
        com.pulumi.azurenative.media.inputs.PresentationTimeRangeArgs.builder()
            .endTimestamp(endTimestamp?.applyValue({ args0 -> args0 }))
            .forceEndTimestamp(forceEndTimestamp?.applyValue({ args0 -> args0 }))
            .liveBackoffDuration(liveBackoffDuration?.applyValue({ args0 -> args0 }))
            .presentationWindowDuration(presentationWindowDuration?.applyValue({ args0 -> args0 }))
            .startTimestamp(startTimestamp?.applyValue({ args0 -> args0 }))
            .timescale(timescale?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PresentationTimeRangeArgs].
 */
@PulumiTagMarker
public class PresentationTimeRangeArgsBuilder internal constructor() {
    private var endTimestamp: Output<Double>? = null

    private var forceEndTimestamp: Output<Boolean>? = null

    private var liveBackoffDuration: Output<Double>? = null

    private var presentationWindowDuration: Output<Double>? = null

    private var startTimestamp: Output<Double>? = null

    private var timescale: Output<Double>? = null

    /**
     * @param value The absolute end time boundary.
     */
    @JvmName("cadqbhfesdldlaxt")
    public suspend fun endTimestamp(`value`: Output<Double>) {
        this.endTimestamp = value
    }

    /**
     * @param value The indicator of forcing existing of end time stamp.
     */
    @JvmName("ynphdlbvgsucdalp")
    public suspend fun forceEndTimestamp(`value`: Output<Boolean>) {
        this.forceEndTimestamp = value
    }

    /**
     * @param value The relative to end right edge.
     */
    @JvmName("fihodilkogmpeuvx")
    public suspend fun liveBackoffDuration(`value`: Output<Double>) {
        this.liveBackoffDuration = value
    }

    /**
     * @param value The relative to end sliding window.
     */
    @JvmName("rctdaddtybejcrnh")
    public suspend fun presentationWindowDuration(`value`: Output<Double>) {
        this.presentationWindowDuration = value
    }

    /**
     * @param value The absolute start time boundary.
     */
    @JvmName("sxtpxgjrraqongwg")
    public suspend fun startTimestamp(`value`: Output<Double>) {
        this.startTimestamp = value
    }

    /**
     * @param value The time scale of time stamps.
     */
    @JvmName("takaxcoqwduhvljy")
    public suspend fun timescale(`value`: Output<Double>) {
        this.timescale = value
    }

    /**
     * @param value The absolute end time boundary.
     */
    @JvmName("yhdfkqlvdwtcnius")
    public suspend fun endTimestamp(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTimestamp = mapped
    }

    /**
     * @param value The indicator of forcing existing of end time stamp.
     */
    @JvmName("prskqhcpktvyvcwe")
    public suspend fun forceEndTimestamp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceEndTimestamp = mapped
    }

    /**
     * @param value The relative to end right edge.
     */
    @JvmName("cipaohxusrccqlos")
    public suspend fun liveBackoffDuration(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.liveBackoffDuration = mapped
    }

    /**
     * @param value The relative to end sliding window.
     */
    @JvmName("twgckeqvolllmuun")
    public suspend fun presentationWindowDuration(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presentationWindowDuration = mapped
    }

    /**
     * @param value The absolute start time boundary.
     */
    @JvmName("hyvtgoijaotyhldi")
    public suspend fun startTimestamp(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTimestamp = mapped
    }

    /**
     * @param value The time scale of time stamps.
     */
    @JvmName("ecgjouguxmajdmsv")
    public suspend fun timescale(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timescale = mapped
    }

    internal fun build(): PresentationTimeRangeArgs = PresentationTimeRangeArgs(
        endTimestamp = endTimestamp,
        forceEndTimestamp = forceEndTimestamp,
        liveBackoffDuration = liveBackoffDuration,
        presentationWindowDuration = presentationWindowDuration,
        startTimestamp = startTimestamp,
        timescale = timescale,
    )
}
