@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.PresetConfigurationsArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.Complexity
import com.pulumi.azurenative.media.kotlin.enums.InterleaveOutput
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An object of optional configuration settings for encoder.
 * @property complexity Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
 * @property interleaveOutput Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
 * @property keyFrameIntervalInSeconds The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
 * @property maxBitrateBps The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
 * @property maxHeight The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
 * @property maxLayers The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
 * @property minBitrateBps The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
 * @property minHeight The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
 */
public data class PresetConfigurationsArgs(
    public val complexity: Output<Either<String, Complexity>>? = null,
    public val interleaveOutput: Output<Either<String, InterleaveOutput>>? = null,
    public val keyFrameIntervalInSeconds: Output<Double>? = null,
    public val maxBitrateBps: Output<Int>? = null,
    public val maxHeight: Output<Int>? = null,
    public val maxLayers: Output<Int>? = null,
    public val minBitrateBps: Output<Int>? = null,
    public val minHeight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.PresetConfigurationsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.PresetConfigurationsArgs =
        com.pulumi.azurenative.media.inputs.PresetConfigurationsArgs.builder()
            .complexity(
                complexity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interleaveOutput(
                interleaveOutput?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .keyFrameIntervalInSeconds(keyFrameIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .maxBitrateBps(maxBitrateBps?.applyValue({ args0 -> args0 }))
            .maxHeight(maxHeight?.applyValue({ args0 -> args0 }))
            .maxLayers(maxLayers?.applyValue({ args0 -> args0 }))
            .minBitrateBps(minBitrateBps?.applyValue({ args0 -> args0 }))
            .minHeight(minHeight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PresetConfigurationsArgs].
 */
@PulumiTagMarker
public class PresetConfigurationsArgsBuilder internal constructor() {
    private var complexity: Output<Either<String, Complexity>>? = null

    private var interleaveOutput: Output<Either<String, InterleaveOutput>>? = null

    private var keyFrameIntervalInSeconds: Output<Double>? = null

    private var maxBitrateBps: Output<Int>? = null

    private var maxHeight: Output<Int>? = null

    private var maxLayers: Output<Int>? = null

    private var minBitrateBps: Output<Int>? = null

    private var minHeight: Output<Int>? = null

    /**
     * @param value Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
     */
    @JvmName("tfqbhwspdxecoohp")
    public suspend fun complexity(`value`: Output<Either<String, Complexity>>) {
        this.complexity = value
    }

    /**
     * @param value Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
     */
    @JvmName("wbgxkcfdnamsqiqd")
    public suspend fun interleaveOutput(`value`: Output<Either<String, InterleaveOutput>>) {
        this.interleaveOutput = value
    }

    /**
     * @param value The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
     */
    @JvmName("hyxcfvcawgjkejfa")
    public suspend fun keyFrameIntervalInSeconds(`value`: Output<Double>) {
        this.keyFrameIntervalInSeconds = value
    }

    /**
     * @param value The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
     */
    @JvmName("eurmoompjodtgpsf")
    public suspend fun maxBitrateBps(`value`: Output<Int>) {
        this.maxBitrateBps = value
    }

    /**
     * @param value The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
     */
    @JvmName("yqpvjysmkuhxtheo")
    public suspend fun maxHeight(`value`: Output<Int>) {
        this.maxHeight = value
    }

    /**
     * @param value The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
     */
    @JvmName("muptsuklsdwdqwhj")
    public suspend fun maxLayers(`value`: Output<Int>) {
        this.maxLayers = value
    }

    /**
     * @param value The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
     */
    @JvmName("twflpdihpcpqwfgg")
    public suspend fun minBitrateBps(`value`: Output<Int>) {
        this.minBitrateBps = value
    }

    /**
     * @param value The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
     */
    @JvmName("ougbkvkfivtvymum")
    public suspend fun minHeight(`value`: Output<Int>) {
        this.minHeight = value
    }

    /**
     * @param value Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
     */
    @JvmName("spqfkiaurvxtylpw")
    public suspend fun complexity(`value`: Either<String, Complexity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
     */
    @JvmName("lxtpogqmqqokkbiu")
    public fun complexity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Complexity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
     */
    @JvmName("ngdcimlvvukferax")
    public fun complexity(`value`: Complexity) {
        val toBeMapped = Either.ofRight<String, Complexity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
     */
    @JvmName("cesnlagotlqiwgir")
    public suspend fun interleaveOutput(`value`: Either<String, InterleaveOutput>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interleaveOutput = mapped
    }

    /**
     * @param value Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
     */
    @JvmName("syucnkesaekenewt")
    public fun interleaveOutput(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InterleaveOutput>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interleaveOutput = mapped
    }

    /**
     * @param value Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
     */
    @JvmName("eprggsoxtersluqw")
    public fun interleaveOutput(`value`: InterleaveOutput) {
        val toBeMapped = Either.ofRight<String, InterleaveOutput>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interleaveOutput = mapped
    }

    /**
     * @param value The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
     */
    @JvmName("vdryhywyyiktgugv")
    public suspend fun keyFrameIntervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameIntervalInSeconds = mapped
    }

    /**
     * @param value The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
     */
    @JvmName("swkeuwqinggwmhyv")
    public suspend fun maxBitrateBps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBitrateBps = mapped
    }

    /**
     * @param value The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
     */
    @JvmName("jqftjcohfjgwfobr")
    public suspend fun maxHeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxHeight = mapped
    }

    /**
     * @param value The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
     */
    @JvmName("qdejciccplgrmqlk")
    public suspend fun maxLayers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxLayers = mapped
    }

    /**
     * @param value The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
     */
    @JvmName("bvflupeutfdacrin")
    public suspend fun minBitrateBps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minBitrateBps = mapped
    }

    /**
     * @param value The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
     */
    @JvmName("ruigjxjxjasxwrxj")
    public suspend fun minHeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minHeight = mapped
    }

    internal fun build(): PresetConfigurationsArgs = PresetConfigurationsArgs(
        complexity = complexity,
        interleaveOutput = interleaveOutput,
        keyFrameIntervalInSeconds = keyFrameIntervalInSeconds,
        maxBitrateBps = maxBitrateBps,
        maxHeight = maxHeight,
        maxLayers = maxLayers,
        minBitrateBps = minBitrateBps,
        minHeight = minHeight,
    )
}
