@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ResourceIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property useSystemAssignedIdentity Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
 * @property userAssignedIdentity The user assigned managed identity's ARM ID to use when accessing a resource.
 */
public data class ResourceIdentityArgs(
    public val useSystemAssignedIdentity: Output<Boolean>,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.media.inputs.ResourceIdentityArgs.builder()
            .useSystemAssignedIdentity(useSystemAssignedIdentity.applyValue({ args0 -> args0 }))
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var useSystemAssignedIdentity: Output<Boolean>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
     */
    @JvmName("smfxmnjidipqwpnl")
    public suspend fun useSystemAssignedIdentity(`value`: Output<Boolean>) {
        this.useSystemAssignedIdentity = value
    }

    /**
     * @param value The user assigned managed identity's ARM ID to use when accessing a resource.
     */
    @JvmName("adrxygnxrysjblnm")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
     */
    @JvmName("nqipqcrdocrjuoks")
    public suspend fun useSystemAssignedIdentity(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useSystemAssignedIdentity = mapped
    }

    /**
     * @param value The user assigned managed identity's ARM ID to use when accessing a resource.
     */
    @JvmName("euwmkvhumasfwnlr")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        useSystemAssignedIdentity = useSystemAssignedIdentity ?: throw
            PulumiNullFieldException("useSystemAssignedIdentity"),
        userAssignedIdentity = userAssignedIdentity,
    )
}
