@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.SelectVideoTrackByIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Select video tracks from the input by specifying a track identifier.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectVideoTrackById'.
 * @property trackId Track identifier to select
 */
public data class SelectVideoTrackByIdArgs(
    public val odataType: Output<String>,
    public val trackId: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.SelectVideoTrackByIdArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.SelectVideoTrackByIdArgs =
        com.pulumi.azurenative.media.inputs.SelectVideoTrackByIdArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .trackId(trackId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectVideoTrackByIdArgs].
 */
@PulumiTagMarker
public class SelectVideoTrackByIdArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    private var trackId: Output<Double>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectVideoTrackById'.
     */
    @JvmName("vpeiokjmgbtjjoav")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Track identifier to select
     */
    @JvmName("rgdcfjfoprtoiwvo")
    public suspend fun trackId(`value`: Output<Double>) {
        this.trackId = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectVideoTrackById'.
     */
    @JvmName("mfdqsxbdoijlwxee")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Track identifier to select
     */
    @JvmName("duhpneujsodivfps")
    public suspend fun trackId(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackId = mapped
    }

    internal fun build(): SelectVideoTrackByIdArgs = SelectVideoTrackByIdArgs(
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        trackId = trackId ?: throw PulumiNullFieldException("trackId"),
    )
}
