@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify configurations of Widevine in Streaming Policy
 * @property customLicenseAcquisitionUrlTemplate Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
 */
public data class StreamingPolicyWidevineConfigurationArgs(
    public val customLicenseAcquisitionUrlTemplate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs =
        com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs.builder()
            .customLicenseAcquisitionUrlTemplate(
                customLicenseAcquisitionUrlTemplate?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StreamingPolicyWidevineConfigurationArgs].
 */
@PulumiTagMarker
public class StreamingPolicyWidevineConfigurationArgsBuilder internal constructor() {
    private var customLicenseAcquisitionUrlTemplate: Output<String>? = null

    /**
     * @param value Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("wswvbxgtoxbbnwgc")
    public suspend fun customLicenseAcquisitionUrlTemplate(`value`: Output<String>) {
        this.customLicenseAcquisitionUrlTemplate = value
    }

    /**
     * @param value Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("rrwhqwoinwqviwds")
    public suspend fun customLicenseAcquisitionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLicenseAcquisitionUrlTemplate = mapped
    }

    internal fun build(): StreamingPolicyWidevineConfigurationArgs =
        StreamingPolicyWidevineConfigurationArgs(
            customLicenseAcquisitionUrlTemplate = customLicenseAcquisitionUrlTemplate,
        )
}
