@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.TransformOutputArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.OnErrorType
import com.pulumi.azurenative.media.kotlin.enums.Priority
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
 * @property onError A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
 * @property preset Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
 * @property relativePriority Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
 */
public data class TransformOutputArgs(
    public val onError: Output<Either<String, OnErrorType>>? = null,
    public val preset: Output<Any>,
    public val relativePriority: Output<Either<String, Priority>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.TransformOutputArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.TransformOutputArgs =
        com.pulumi.azurenative.media.inputs.TransformOutputArgs.builder()
            .onError(
                onError?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .preset(preset.applyValue({ args0 -> args0 }))
            .relativePriority(
                relativePriority?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [TransformOutputArgs].
 */
@PulumiTagMarker
public class TransformOutputArgsBuilder internal constructor() {
    private var onError: Output<Either<String, OnErrorType>>? = null

    private var preset: Output<Any>? = null

    private var relativePriority: Output<Either<String, Priority>>? = null

    /**
     * @param value A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
     */
    @JvmName("hioyutbjcggfwgma")
    public suspend fun onError(`value`: Output<Either<String, OnErrorType>>) {
        this.onError = value
    }

    /**
     * @param value Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
     */
    @JvmName("elbbhqhiancajxok")
    public suspend fun preset(`value`: Output<Any>) {
        this.preset = value
    }

    /**
     * @param value Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
     */
    @JvmName("uscajhmhsaretpyg")
    public suspend fun relativePriority(`value`: Output<Either<String, Priority>>) {
        this.relativePriority = value
    }

    /**
     * @param value A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
     */
    @JvmName("vagfxmexnjukfocu")
    public suspend fun onError(`value`: Either<String, OnErrorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onError = mapped
    }

    /**
     * @param value A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
     */
    @JvmName("iktvoqplupxqqrfj")
    public fun onError(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OnErrorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onError = mapped
    }

    /**
     * @param value A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
     */
    @JvmName("nkwsqwsfwyaodhsj")
    public fun onError(`value`: OnErrorType) {
        val toBeMapped = Either.ofRight<String, OnErrorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onError = mapped
    }

    /**
     * @param value Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
     */
    @JvmName("crnbovxoyiehxjhc")
    public suspend fun preset(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preset = mapped
    }

    /**
     * @param value Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
     */
    @JvmName("wesicfvnptrjxqjh")
    public suspend fun relativePriority(`value`: Either<String, Priority>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePriority = mapped
    }

    /**
     * @param value Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
     */
    @JvmName("mstnfhqmmqcdyovt")
    public fun relativePriority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Priority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativePriority = mapped
    }

    /**
     * @param value Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
     */
    @JvmName("rgpllqssqwcxttjn")
    public fun relativePriority(`value`: Priority) {
        val toBeMapped = Either.ofRight<String, Priority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativePriority = mapped
    }

    internal fun build(): TransformOutputArgs = TransformOutputArgs(
        onError = onError,
        preset = preset ?: throw PulumiNullFieldException("preset"),
        relativePriority = relativePriority,
    )
}
