@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.UtcClipTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.UtcClipTime'.
 * @property time The time position on the timeline of the input media based on Utc time.
 */
public data class UtcClipTimeArgs(
    public val odataType: Output<String>,
    public val time: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.UtcClipTimeArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.UtcClipTimeArgs =
        com.pulumi.azurenative.media.inputs.UtcClipTimeArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .time(time.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UtcClipTimeArgs].
 */
@PulumiTagMarker
public class UtcClipTimeArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    private var time: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.UtcClipTime'.
     */
    @JvmName("hwejrfnrfurcltys")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The time position on the timeline of the input media based on Utc time.
     */
    @JvmName("yhnxgpeauganfwiu")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.UtcClipTime'.
     */
    @JvmName("fxduywdktnsudakq")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The time position on the timeline of the input media based on Utc time.
     */
    @JvmName("yppmuwpixhiwtgfq")
    public suspend fun time(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): UtcClipTimeArgs = UtcClipTimeArgs(
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        time = time ?: throw PulumiNullFieldException("time"),
    )
}
