@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.VideoTrackDescriptorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A TrackSelection to select video tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
 */
public data class VideoTrackDescriptorArgs(
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.VideoTrackDescriptorArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.VideoTrackDescriptorArgs =
        com.pulumi.azurenative.media.inputs.VideoTrackDescriptorArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoTrackDescriptorArgs].
 */
@PulumiTagMarker
public class VideoTrackDescriptorArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
     */
    @JvmName("bhwrgxiovbbrmgia")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
     */
    @JvmName("yqbqccbqlwircwau")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): VideoTrackDescriptorArgs = VideoTrackDescriptorArgs(
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
