@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identity The Key Vault identity.
 * @property keyVaultProperties The properties of the key used to encrypt the account.
 * @property status The current status of the Key Vault mapping.
 * @property type The type of key used to encrypt the Account Key.
 */
public data class AccountEncryptionResponse(
    public val identity: ResourceIdentityResponse? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AccountEncryptionResponse):
            AccountEncryptionResponse = AccountEncryptionResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
