@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The streaming endpoint current sku.
 * @property capacity The streaming endpoint sku capacity.
 * @property name The streaming endpoint sku name.
 */
public data class ArmStreamingEndpointCurrentSkuResponse(
    public val capacity: Int? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ArmStreamingEndpointCurrentSkuResponse):
            ArmStreamingEndpointCurrentSkuResponse = ArmStreamingEndpointCurrentSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
