@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Represents a policy option.
 * @property configuration The key delivery configuration.
 * @property name The Policy Option description.
 * @property policyOptionId The legacy Policy Option ID.
 * @property restriction The requirements that must be met to deliver keys with this configuration
 */
public data class ContentKeyPolicyOptionResponse(
    public val configuration: Any,
    public val name: String? = null,
    public val policyOptionId: String,
    public val restriction: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyOptionResponse):
            ContentKeyPolicyOptionResponse = ContentKeyPolicyOptionResponse(
            configuration = javaType.configuration(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            policyOptionId = javaType.policyOptionId(),
            restriction = javaType.restriction(),
        )
    }
}
