@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies a RSA key for token validation
 * @property exponent The RSA Parameter exponent
 * @property modulus The RSA Parameter modulus
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
 */
public data class ContentKeyPolicyRsaTokenKeyResponse(
    public val exponent: String,
    public val modulus: String,
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyRsaTokenKeyResponse):
            ContentKeyPolicyRsaTokenKeyResponse = ContentKeyPolicyRsaTokenKeyResponse(
            exponent = javaType.exponent(),
            modulus = javaType.modulus(),
            odataType = javaType.odataType(),
        )
    }
}
