@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies a symmetric key for token validation.
 * @property keyValue The key value of the key
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
 */
public data class ContentKeyPolicySymmetricTokenKeyResponse(
    public val keyValue: String,
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicySymmetricTokenKeyResponse):
            ContentKeyPolicySymmetricTokenKeyResponse = ContentKeyPolicySymmetricTokenKeyResponse(
            keyValue = javaType.keyValue(),
            odataType = javaType.odataType(),
        )
    }
}
