@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
 */
public data class ContentKeyPolicyUnknownRestrictionResponse(
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyUnknownRestrictionResponse):
            ContentKeyPolicyUnknownRestrictionResponse = ContentKeyPolicyUnknownRestrictionResponse(
            odataType = javaType.odataType(),
        )
    }
}
