@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A codec flag, which tells the encoder to copy the input audio bitstream.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.CopyAudio'.
 */
public data class CopyAudioResponse(
    public val label: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.CopyAudioResponse):
            CopyAudioResponse = CopyAudioResponse(
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
