@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data needed to decrypt asset files encrypted with legacy storage encryption.
 * @property assetFileEncryptionMetadata Asset File encryption metadata.
 * @property key The Asset File storage encryption key.
 */
public data class GetAssetEncryptionKeyResult(
    public val assetFileEncryptionMetadata: List<AssetFileEncryptionMetadataResponse>? = null,
    public val key: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetAssetEncryptionKeyResult):
            GetAssetEncryptionKeyResult = GetAssetEncryptionKeyResult(
            assetFileEncryptionMetadata = javaType.assetFileEncryptionMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.AssetFileEncryptionMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
        )
    }
}
