@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
 * @property correlationData Customer provided key, value pairs that will be returned in Job and JobOutput state events.
 * @property created The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
 * @property description Optional customer supplied description of the Job.
 * @property endTime The UTC date and time at which this Job finished processing.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property input The inputs for the Job.
 * @property lastModified The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
 * @property name The name of the resource
 * @property outputs The outputs for the Job.
 * @property priority Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
 * @property startTime The UTC date and time at which this Job began processing.
 * @property state The current state of the job.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetJobResult(
    public val correlationData: Map<String, String>? = null,
    public val created: String,
    public val description: String? = null,
    public val endTime: String,
    public val id: String,
    public val input: Any,
    public val lastModified: String,
    public val name: String,
    public val outputs: List<JobOutputAssetResponse>,
    public val priority: String? = null,
    public val startTime: String,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetJobResult): GetJobResult =
            GetJobResult(
                correlationData = javaType.correlationData().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                created = javaType.created(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                endTime = javaType.endTime(),
                id = javaType.id(),
                input = javaType.input(),
                lastModified = javaType.lastModified(),
                name = javaType.name(),
                outputs = javaType.outputs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.JobOutputAssetResponse.Companion.toKotlin(args0)
                    })
                }),
                priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
                startTime = javaType.startTime(),
                state = javaType.state(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
