@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The HLS setting for a track.
 * @property characteristics The characteristics for the HLS setting.
 * @property default The default for the HLS setting.
 * @property forced The forced for the HLS setting.
 */
public data class HlsSettingsResponse(
    public val characteristics: String? = null,
    public val default: Boolean? = null,
    public val forced: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.HlsSettingsResponse):
            HlsSettingsResponse = HlsSettingsResponse(
            characteristics = javaType.characteristics().map({ args0 -> args0 }).orElse(null),
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            forced = javaType.forced().map({ args0 -> args0 }).orElse(null),
        )
    }
}
