@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The IP address range in the CIDR scheme.
 * @property address The IP address.
 * @property name The friendly name for the IP address range.
 * @property subnetPrefixLength The subnet mask prefix length (see CIDR notation).
 */
public data class IPRangeResponse(
    public val address: String? = null,
    public val name: String? = null,
    public val subnetPrefixLength: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.IPRangeResponse):
            IPRangeResponse = IPRangeResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            subnetPrefixLength = javaType.subnetPrefixLength().map({ args0 -> args0 }).orElse(null),
        )
    }
}
