@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of JobOutput errors.
 * @property code Code describing the error detail.
 * @property message A human-readable representation of the error.
 */
public data class JobErrorDetailResponse(
    public val code: String,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JobErrorDetailResponse):
            JobErrorDetailResponse = JobErrorDetailResponse(
            code = javaType.code(),
            message = javaType.message(),
        )
    }
}
