@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The live event ingestion telemetry data.
 * @property begin Ingestion begin time in UTC.
 * @property end Ingestion end time in UTC. Empty if it's not stopped yet.
 * @property endReason Reason why ingestion stops. Empty if it's not stopped yet. E.g) Service Stopped. No Ingestion.
 * @property ingestInterruptions IngestInterruption entry list.
 * @property streamName Ingestion stream name.
 */
public data class LiveEventIngestionResponse(
    public val begin: String? = null,
    public val end: String? = null,
    public val endReason: String? = null,
    public val ingestInterruptions: List<LiveEventIngestInterruptionResponse>? = null,
    public val streamName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventIngestionResponse):
            LiveEventIngestionResponse = LiveEventIngestionResponse(
            begin = javaType.begin().map({ args0 -> args0 }).orElse(null),
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            endReason = javaType.endReason().map({ args0 -> args0 }).orElse(null),
            ingestInterruptions = javaType.ingestInterruptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventIngestInterruptionResponse.Companion.toKotlin(args0)
                })
            }),
            streamName = javaType.streamName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
