@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The live event input.
 * @property accessControl Access control for live event input.
 * @property accessToken A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
 * @property endpoints The input endpoints for the live event.
 * @property keyFrameIntervalDuration ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
 * @property streamingProtocol The input protocol for the live event. This is specified at creation time and cannot be updated.
 * @property timedMetadataEndpoints The metadata endpoints for the live event.
 */
public data class LiveEventInputResponse(
    public val accessControl: LiveEventInputAccessControlResponse? = null,
    public val accessToken: String? = null,
    public val endpoints: List<LiveEventEndpointResponse>? = null,
    public val keyFrameIntervalDuration: String? = null,
    public val streamingProtocol: String,
    public val timedMetadataEndpoints: List<LiveEventTimedMetadataEndpointResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventInputResponse):
            LiveEventInputResponse = LiveEventInputResponse(
            accessControl = javaType.accessControl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventInputAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            keyFrameIntervalDuration = javaType.keyFrameIntervalDuration().map({ args0 -> args0 }).orElse(null),
            streamingProtocol = javaType.streamingProtocol(),
            timedMetadataEndpoints = javaType.timedMetadataEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventTimedMetadataEndpointResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
