@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The live event track status.
 * @property expectedBitrate Expected bitrate for this track.
 * @property incomingBitrate Average incoming bitrate for last 20 seconds when live event is running.
 * @property ingestDrift Current ingest drift value in seconds for last 1 minute.
 * @property requestReceived Total number of timed metadata request received.
 * @property requestSucceeded Total number of successful timed metadata request received.
 * @property trackId Track Id.
 */
public data class LiveEventTrackStatusResponse(
    public val expectedBitrate: Double? = null,
    public val incomingBitrate: Double? = null,
    public val ingestDrift: String? = null,
    public val requestReceived: Double? = null,
    public val requestSucceeded: Double? = null,
    public val trackId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventTrackStatusResponse):
            LiveEventTrackStatusResponse = LiveEventTrackStatusResponse(
            expectedBitrate = javaType.expectedBitrate().map({ args0 -> args0 }).orElse(null),
            incomingBitrate = javaType.incomingBitrate().map({ args0 -> args0 }).orElse(null),
            ingestDrift = javaType.ingestDrift().map({ args0 -> args0 }).orElse(null),
            requestReceived = javaType.requestReceived().map({ args0 -> args0 }).orElse(null),
            requestSucceeded = javaType.requestSucceeded().map({ args0 -> args0 }).orElse(null),
            trackId = javaType.trackId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
