@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An endpoint which must be connected over TLS/SSL.
 * @property credentials Polymorphic credentials to present to the endpoint.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphTlsEndpoint'.
 * @property trustedCertificates What certificates should be trusted when authenticating a TLS connection. Null designates that Azure Media's source of trust should be used.
 * @property url Url for the endpoint.
 * @property validationOptions Validation options to use when authenticating a TLS connection. By default, strict validation is used.
 */
public data class MediaGraphTlsEndpointResponse(
    public val credentials: MediaGraphUsernamePasswordCredentialsResponse? = null,
    public val odataType: String,
    public val trustedCertificates: MediaGraphPemCertificateListResponse? = null,
    public val url: String,
    public val validationOptions: MediaGraphTlsValidationOptionsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphTlsEndpointResponse):
            MediaGraphTlsEndpointResponse = MediaGraphTlsEndpointResponse(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaGraphUsernamePasswordCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            odataType = javaType.odataType(),
            trustedCertificates = javaType.trustedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaGraphPemCertificateListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url(),
            validationOptions = javaType.validationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaGraphTlsValidationOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
