@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property useSystemAssignedIdentity Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
 * @property userAssignedIdentity The user assigned managed identity's ARM ID to use when accessing a resource.
 */
public data class ResourceIdentityResponse(
    public val useSystemAssignedIdentity: Boolean,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ResourceIdentityResponse):
            ResourceIdentityResponse = ResourceIdentityResponse(
            useSystemAssignedIdentity = javaType.useSystemAssignedIdentity(),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
