@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Class to specify properties of all content keys in Streaming Policy
 * @property defaultKey Default content key for an encryption scheme
 * @property keyToTrackMappings Representing tracks needs separate content key
 */
public data class StreamingPolicyContentKeysResponse(
    public val defaultKey: DefaultKeyResponse? = null,
    public val keyToTrackMappings: List<StreamingPolicyContentKeyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StreamingPolicyContentKeysResponse):
            StreamingPolicyContentKeysResponse = StreamingPolicyContentKeysResponse(
            defaultKey = javaType.defaultKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.DefaultKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyToTrackMappings = javaType.keyToTrackMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyContentKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
