@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
 * @property displayName The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
 * @property fileName The file name to the source file. This file is located in the storage container of the asset.
 * @property hlsSettings The HLS specific setting for the text track.
 * @property languageCode The RFC5646 language code for the text track.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.TextTrack'.
 * @property playerVisibility When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
 */
public data class TextTrackResponse(
    public val displayName: String? = null,
    public val fileName: String? = null,
    public val hlsSettings: HlsSettingsResponse? = null,
    public val languageCode: String,
    public val odataType: String,
    public val playerVisibility: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.TextTrackResponse):
            TextTrackResponse = TextTrackResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            hlsSettings = javaType.hlsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.HlsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            languageCode = javaType.languageCode(),
            odataType = javaType.odataType(),
            playerVisibility = javaType.playerVisibility().map({ args0 -> args0 }).orElse(null),
        )
    }
}
