@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AvsAssessmentsOperation].
 */
@PulumiTagMarker
public class AvsAssessmentsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AvsAssessmentsOperationArgs = AvsAssessmentsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AvsAssessmentsOperationArgsBuilder.() -> Unit) {
        val builder = AvsAssessmentsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AvsAssessmentsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.AvsAssessmentsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AvsAssessmentsOperation(builtJavaResource)
    }
}

/**
 * AVS assessment resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### AvsAssessmentsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var avsAssessmentsOperation = new AzureNative.Migrate.AvsAssessmentsOperation("avsAssessmentsOperation", new()
 *     {
 *         AssessmentName = "asm2",
 *         AzureLocation = "EastUs",
 *         AzureOfferCode = "MSAZR0003P",
 *         Currency = "USD",
 *         DedupeCompression = 1.5,
 *         DiscountPercentage = 0,
 *         FailuresToTolerateAndRaidLevel = "Ftt1Raid1",
 *         GroupName = "kuchatur-test",
 *         IsStretchClusterEnabled = true,
 *         MemOvercommit = 1,
 *         NodeType = "AV36",
 *         Percentile = "Percentile95",
 *         PerfDataEndTime = "2023-09-26T13:35:56.5671462Z",
 *         PerfDataStartTime = "2023-09-25T13:35:56.5671462Z",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ReservedInstance = "RI3Year",
 *         ResourceGroupName = "ayagrawrg",
 *         ScalingFactor = 1,
 *         SizingCriterion = "AsOnPremises",
 *         TimeRange = "Day",
 *         VcpuOversubscription = 4,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAvsAssessmentsOperation(ctx, "avsAssessmentsOperation", &migrate.AvsAssessmentsOperationArgs{
 * 			AssessmentName:                 pulumi.String("asm2"),
 * 			AzureLocation:                  pulumi.String("EastUs"),
 * 			AzureOfferCode:                 pulumi.String("MSAZR0003P"),
 * 			Currency:                       pulumi.String("USD"),
 * 			DedupeCompression:              pulumi.Float64(1.5),
 * 			DiscountPercentage:             pulumi.Float64(0),
 * 			FailuresToTolerateAndRaidLevel: pulumi.String("Ftt1Raid1"),
 * 			GroupName:                      pulumi.String("kuchatur-test"),
 * 			IsStretchClusterEnabled:        pulumi.Bool(true),
 * 			MemOvercommit:                  pulumi.Float64(1),
 * 			NodeType:                       pulumi.String("AV36"),
 * 			Percentile:                     pulumi.String("Percentile95"),
 * 			PerfDataEndTime:                pulumi.String("2023-09-26T13:35:56.5671462Z"),
 * 			PerfDataStartTime:              pulumi.String("2023-09-25T13:35:56.5671462Z"),
 * 			ProjectName:                    pulumi.String("app18700project"),
 * 			ProvisioningState:              pulumi.String("Succeeded"),
 * 			ReservedInstance:               pulumi.String("RI3Year"),
 * 			ResourceGroupName:              pulumi.String("ayagrawrg"),
 * 			ScalingFactor:                  pulumi.Float64(1),
 * 			SizingCriterion:                pulumi.String("AsOnPremises"),
 * 			TimeRange:                      pulumi.String("Day"),
 * 			VcpuOversubscription:           pulumi.Float64(4),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AvsAssessmentsOperation;
 * import com.pulumi.azurenative.migrate.AvsAssessmentsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var avsAssessmentsOperation = new AvsAssessmentsOperation("avsAssessmentsOperation", AvsAssessmentsOperationArgs.builder()
 *             .assessmentName("asm2")
 *             .azureLocation("EastUs")
 *             .azureOfferCode("MSAZR0003P")
 *             .currency("USD")
 *             .dedupeCompression(1.5)
 *             .discountPercentage(0)
 *             .failuresToTolerateAndRaidLevel("Ftt1Raid1")
 *             .groupName("kuchatur-test")
 *             .isStretchClusterEnabled(true)
 *             .memOvercommit(1)
 *             .nodeType("AV36")
 *             .percentile("Percentile95")
 *             .perfDataEndTime("2023-09-26T13:35:56.5671462Z")
 *             .perfDataStartTime("2023-09-25T13:35:56.5671462Z")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .reservedInstance("RI3Year")
 *             .resourceGroupName("ayagrawrg")
 *             .scalingFactor(1)
 *             .sizingCriterion("AsOnPremises")
 *             .timeRange("Day")
 *             .vcpuOversubscription(4)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AvsAssessmentsOperation asm2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/avsAssessments/{assessmentName}
 * ```
 */
public class AvsAssessmentsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.AvsAssessmentsOperation,
) : KotlinCustomResource(javaResource, AvsAssessmentsOperationMapper) {
    /**
     * Gets the assessment error summary.
     *             This is the number of machines
     * affected by each type of error in this assessment.
     */
    public val assessmentErrorSummary: Output<Map<String, Int>>
        get() = javaResource.assessmentErrorSummary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Assessment type of the assessment.
     */
    public val assessmentType: Output<String>
        get() = javaResource.assessmentType().applyValue({ args0 -> args0 })

    /**
     * Azure Location or Azure region where to which the machines will be migrated.
     */
    public val azureLocation: Output<String>?
        get() = javaResource.azureLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Offer code according to which cost estimation is done.
     */
    public val azureOfferCode: Output<String>?
        get() = javaResource.azureOfferCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Confidence Rating in Percentage.
     */
    public val confidenceRatingInPercentage: Output<Double>
        get() = javaResource.confidenceRatingInPercentage().applyValue({ args0 -> args0 })

    /**
     * Predicted CPU utilization.
     */
    public val cpuUtilization: Output<Double>
        get() = javaResource.cpuUtilization().applyValue({ args0 -> args0 })

    /**
     * Date and Time when assessment was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Currency in which prices should be reported.
     */
    public val currency: Output<String>?
        get() = javaResource.currency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * De-duplication compression.
     */
    public val dedupeCompression: Output<Double>?
        get() = javaResource.dedupeCompression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom discount percentage.
     */
    public val discountPercentage: Output<Double>?
        get() = javaResource.discountPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Failures to tolerate and RAID level in a common property.
     */
    public val failuresToTolerateAndRaidLevel: Output<String>?
        get() = javaResource.failuresToTolerateAndRaidLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the group type for the assessment.
     */
    public val groupType: Output<String>
        get() = javaResource.groupType().applyValue({ args0 -> args0 })

    /**
     * Is Stretch Cluster Enabled.
     */
    public val isStretchClusterEnabled: Output<Boolean>?
        get() = javaResource.isStretchClusterEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Limiting factor.
     */
    public val limitingFactor: Output<String>
        get() = javaResource.limitingFactor().applyValue({ args0 -> args0 })

    /**
     * Memory overcommit.
     */
    public val memOvercommit: Output<Double>?
        get() = javaResource.memOvercommit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * AVS node type.
     */
    public val nodeType: Output<String>?
        get() = javaResource.nodeType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of machines part of the assessment.
     */
    public val numberOfMachines: Output<Int>
        get() = javaResource.numberOfMachines().applyValue({ args0 -> args0 })

    /**
     * Recommended number of nodes.
     */
    public val numberOfNodes: Output<Int>
        get() = javaResource.numberOfNodes().applyValue({ args0 -> args0 })

    /**
     * Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    public val percentile: Output<String>?
        get() = javaResource.percentile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the end time to consider performance data for assessment.
     */
    public val perfDataEndTime: Output<String>?
        get() = javaResource.perfDataEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the start time to consider performance data for assessment.
     */
    public val perfDataStartTime: Output<String>?
        get() = javaResource.perfDataStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time when the Azure Prices were queried. Date-Time represented in ISO-8601
     * format.
     */
    public val pricesTimestamp: Output<String>
        get() = javaResource.pricesTimestamp().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Predicted RAM utilization.
     */
    public val ramUtilization: Output<Double>
        get() = javaResource.ramUtilization().applyValue({ args0 -> args0 })

    /**
     * Reserved instance.
     */
    public val reservedInstance: Output<String>?
        get() = javaResource.reservedInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    public val scalingFactor: Output<Double>?
        get() = javaResource.scalingFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schema version.
     */
    public val schemaVersion: Output<String>
        get() = javaResource.schemaVersion().applyValue({ args0 -> args0 })

    /**
     * Assessment sizing criterion.
     */
    public val sizingCriterion: Output<String>?
        get() = javaResource.sizingCriterion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User configurable setting to display the Stage of Assessment.
     */
    public val stage: Output<String>
        get() = javaResource.stage().applyValue({ args0 -> args0 })

    /**
     * Whether assessment is in valid state and all machines have been assessed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Predicted storage utilization.
     */
    public val storageUtilization: Output<Double>
        get() = javaResource.storageUtilization().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the Assessment cloud suitability.
     */
    public val suitability: Output<String>
        get() = javaResource.suitability().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the Assessment suitability explanation.
     */
    public val suitabilityExplanation: Output<String>
        get() = javaResource.suitabilityExplanation().applyValue({ args0 -> args0 })

    /**
     * Cloud suitability summary for all the machines in the assessment.
     */
    public val suitabilitySummary: Output<Map<String, Int>>
        get() = javaResource.suitabilitySummary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    public val timeRange: Output<String>?
        get() = javaResource.timeRange().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Predicted total CPU cores used.
     */
    public val totalCpuCores: Output<Double>
        get() = javaResource.totalCpuCores().applyValue({ args0 -> args0 })

    /**
     * Total monthly cost.
     */
    public val totalMonthlyCost: Output<Double>
        get() = javaResource.totalMonthlyCost().applyValue({ args0 -> args0 })

    /**
     * Predicted total RAM used in GB.
     */
    public val totalRamInGB: Output<Double>
        get() = javaResource.totalRamInGB().applyValue({ args0 -> args0 })

    /**
     * Predicted total Storage used in GB.
     */
    public val totalStorageInGB: Output<Double>
        get() = javaResource.totalStorageInGB().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Date and Time when assessment was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })

    /**
     * VCPU over subscription.
     */
    public val vcpuOversubscription: Output<Double>?
        get() = javaResource.vcpuOversubscription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AvsAssessmentsOperationMapper : ResourceMapper<AvsAssessmentsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.AvsAssessmentsOperation::class == javaResource::class

    override fun map(javaResource: Resource): AvsAssessmentsOperation =
        AvsAssessmentsOperation(
            javaResource as
                com.pulumi.azurenative.migrate.AvsAssessmentsOperation,
        )
}

/**
 * @see [AvsAssessmentsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AvsAssessmentsOperation].
 */
public suspend fun avsAssessmentsOperation(
    name: String,
    block: suspend AvsAssessmentsOperationResourceBuilder.() -> Unit,
): AvsAssessmentsOperation {
    val builder = AvsAssessmentsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AvsAssessmentsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun avsAssessmentsOperation(name: String): AvsAssessmentsOperation {
    val builder = AvsAssessmentsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
