@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.GroupsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentType
import com.pulumi.azurenative.migrate.kotlin.enums.GroupType
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Group resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### GroupsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupsOperation = new AzureNative.Migrate.GroupsOperation("groupsOperation", new()
 *     {
 *         GroupName = "kuchatur-test",
 *         GroupType = "Default",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ayagrawrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewGroupsOperation(ctx, "groupsOperation", &migrate.GroupsOperationArgs{
 * 			GroupName:         pulumi.String("kuchatur-test"),
 * 			GroupType:         pulumi.String("Default"),
 * 			ProjectName:       pulumi.String("app18700project"),
 * 			ProvisioningState: pulumi.String("Succeeded"),
 * 			ResourceGroupName: pulumi.String("ayagrawrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.GroupsOperation;
 * import com.pulumi.azurenative.migrate.GroupsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupsOperation = new GroupsOperation("groupsOperation", GroupsOperationArgs.builder()
 *             .groupName("kuchatur-test")
 *             .groupType("Default")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:GroupsOperation kuchatur-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}
 * ```
 * @property groupName Group ARM name
 * @property groupType The type of group.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property supportedAssessmentTypes List of assessment types supported on this group.
 */
public data class GroupsOperationArgs(
    public val groupName: Output<String>? = null,
    public val groupType: Output<Either<String, GroupType>>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val supportedAssessmentTypes: Output<List<Either<String, AssessmentType>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.GroupsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.GroupsOperationArgs =
        com.pulumi.azurenative.migrate.GroupsOperationArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .groupType(
                groupType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .supportedAssessmentTypes(
                supportedAssessmentTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GroupsOperationArgs].
 */
@PulumiTagMarker
public class GroupsOperationArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var groupType: Output<Either<String, GroupType>>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var supportedAssessmentTypes: Output<List<Either<String, AssessmentType>>>? = null

    /**
     * @param value Group ARM name
     */
    @JvmName("rqsahfirraqxbxsn")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The type of group.
     */
    @JvmName("psaivjdxraetnuos")
    public suspend fun groupType(`value`: Output<Either<String, GroupType>>) {
        this.groupType = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ndklloywqldkound")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("urcsapvjjpebytru")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wlmktmvydkkwlxot")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of assessment types supported on this group.
     */
    @JvmName("sbgtottdmmvtmrjv")
    public suspend
    fun supportedAssessmentTypes(`value`: Output<List<Either<String, AssessmentType>>>) {
        this.supportedAssessmentTypes = value
    }

    @JvmName("wqajxjoyyuvusrol")
    public suspend fun supportedAssessmentTypes(
        vararg
        values: Output<Either<String, AssessmentType>>,
    ) {
        this.supportedAssessmentTypes = Output.all(values.asList())
    }

    /**
     * @param values List of assessment types supported on this group.
     */
    @JvmName("gyisxekvsvugahev")
    public suspend
    fun supportedAssessmentTypes(values: List<Output<Either<String, AssessmentType>>>) {
        this.supportedAssessmentTypes = Output.all(values)
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("cwsnnnianohneanu")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The type of group.
     */
    @JvmName("kwudnvddpebcrmum")
    public suspend fun groupType(`value`: Either<String, GroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The type of group.
     */
    @JvmName("qgoymtcuomqpbgqa")
    public fun groupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The type of group.
     */
    @JvmName("vkiqxtjhuyaofbvi")
    public fun groupType(`value`: GroupType) {
        val toBeMapped = Either.ofRight<String, GroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("hmjqftcngaxfogkh")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ttxavrmjlguahvqp")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("jiqsrhfgcddctwnr")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("rslldqhxnehwhraa")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ogeqfcfaekyuhvxy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of assessment types supported on this group.
     */
    @JvmName("avbgdbnsggiemhkd")
    public suspend fun supportedAssessmentTypes(`value`: List<Either<String, AssessmentType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedAssessmentTypes = mapped
    }

    /**
     * @param values List of assessment types supported on this group.
     */
    @JvmName("epcbmaivorpvcbpb")
    public suspend fun supportedAssessmentTypes(vararg values: Either<String, AssessmentType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedAssessmentTypes = mapped
    }

    internal fun build(): GroupsOperationArgs = GroupsOperationArgs(
        groupName = groupName,
        groupType = groupType,
        projectName = projectName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        supportedAssessmentTypes = supportedAssessmentTypes,
    )
}
